// nvidia shader library
// http://developer.download.nvidia.com/shaderlibrary/webpages/shader_library.html

uniform sampler2D SceneBuffer : register(s0);
uniform sampler2D NormalTex : register(s1);
uniform float EffectStrength;

float4 main(float2 texCoord:TEXCOORD0):COLOR
{
	float4 normalCol = 2.0*(tex2D(NormalTex, texCoord*2.5)-0.5);
	return tex2D(SceneBuffer, texCoord+normalCol.xy*EffectStrength);
}